package gihyo.lucene.ch6;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.IOException;
import java.util.List;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.cnlp.apachecon.search.QAService;
import org.cnlp.apachecon.search.QAResult;

public class TestQAService {

    static final String[] questions = {
	"SҌ̃vO~O̖{𐄑EĂB",
	"z[y[WĂ̂łACGI悭킩Ȃ̂Œm肽B",
	"WindowsŃrfIҏW@𒲂ׂĂ܂B悢Ql狳ĂB"
    };
    static final Analyzer analyzer = new JapaneseAnalyzer();
    static final QAService service = new QAService();

    public static void main( String[] args ) throws IOException {
	IndexReader reader = IndexReader.open( args[0] );
	for( int i = 0; i < questions.length; i++ )
	    printCandidates( questions[i], reader );
	reader.close();
    }

    static void printCandidates( String question, IndexReader reader ) throws IOException {
	System.out.println( "\n: " + question );
	System.out.println( "========================================" );
	List candidates = service.getCandidates( question, analyzer, reader );
	System.out.println( candidates.size() == 0 ? "\󂲂܂Bq˂̏Ђ͌܂łB" : Integer.toString( candidates.size() ) + "̏Ђ܂B" );
	for( Iterator i = candidates.iterator(); i.hasNext(); ){
	    QAResult result = (QAResult)i.next();
	    System.out.println( "^Cg: " + result.getTitle() );
	    System.out.println( "e: " + result.getCandidate() + "\n" );
	}
    }
}
