package gihyo.lucene.ch6;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.IOException;
import java.util.Map;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.QueryFilter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.MatchAllDocsQuery;

public class TestSecurity {

    static final String[][] permission = {
	{ "" },
	{ "l", "" },
	{ "В" },
	{ "" },
	{ "ے", "", "{", "" }
    };
    static final String[] contents = {
	"ʎЈ{łhLgłBiPj",
	"lX^btƖ{łhLgłB",
	"ВX^bt{łhLgłB",
	"ʎЈ{łhLgłBiQj",
	"ےȏオ{łhLgłB"
    };
    static final String F_PERMISSION = "ANZX";
    static final String F_CONTENT = "Rec";

    static final Analyzer analyzer = new JapaneseAnalyzer();
    static final Directory directory = new RAMDirectory();
    static Map cache = new HashMap();

    public static void main( String[] args ) throws IOException {
	makeIndex();
	secureSearch( "vO}{", new String[]{ "" } );
	secureSearch( "ꖱR", new String[]{ "", "" } );
	secureSearch( "В΂", new String[]{ "", "В", "" } );
	directory.close();
    }

    static void makeIndex() throws IOException {
	IndexWriter writer = new IndexWriter( directory, analyzer, true );
	for( int i = 0; i < contents.length; i++ ){
	    Document doc = new Document();
	    for( int j = 0; j < permission[i].length; j++ ){
		doc.add( new Field( F_PERMISSION, permission[i][j], Field.Store.YES, Field.Index.UN_TOKENIZED ) );
	    }
	    doc.add( new Field( F_CONTENT, contents[i], Field.Store.YES, Field.Index.TOKENIZED ) );
	    writer.addDocument( doc );
	}
	writer.close();
    }

    static void secureSearch( final String name, final String[] roles ) throws IOException {
	System.out.println( "\n" + name + " ̌" );
	System.out.println( "============================================" );
	Filter filter = getFilter( roles );
	IndexSearcher searcher = new IndexSearcher( directory );
	Hits hits = searcher.search( new MatchAllDocsQuery(), filter );
	for( int i = 0; i < hits.length(); i++ ){
	    Document doc = hits.doc( i );
	    System.out.println( doc.get( F_CONTENT ) );
	}
	searcher.close();
    }

    static Filter getFilter( final String[] roles ){
	String key = getKey( roles );
	Filter filter = (Filter)cache.get( key );
	if( filter == null ){
	    //System.out.println( key + " : VFilter쐬܂B" );
	    BooleanQuery bq = new BooleanQuery();
	    for( int i = 0; i < roles.length; i++ ){
		Query query = new TermQuery( new Term( F_PERMISSION, roles[i] ) );
		bq.add( query, BooleanClause.Occur.SHOULD );
	    }
	    filter = new QueryFilter( bq );
	    cache.put( key, filter );
	    return filter;
	}
	//System.out.println( key + " : LbVqbg܂B" );
	return filter;
    }

    static String getKey( final String[] roles ){
	StringBuffer buffer = new StringBuffer();
	for( int i = 0; i < roles.length; i++ ){
	    buffer.append( "+" );
	    buffer.append( roles[i] );
	}
	return buffer.toString();
    }
}
