package gihyo.lucene.ch6;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class TestTermPositionVector {

    static final String CONTENT = "AAA BBB CCC BBB AAA BBB";
    static final String FIELD = "F";
    static final Directory directory = new RAMDirectory();
    static final Analyzer analyzer = new WhitespaceAnalyzer();

    public static void main( String[] args ) throws IOException {
	makeIndex();
	TermFreqVector tfv = IndexReader.open( directory ).getTermFreqVector( 0, FIELD );
	System.out.println( CONTENT );
	System.out.println( "=============================" );
	printTermFreqVector( tfv );
	directory.close();
    }

    static void makeIndex() throws IOException {
	IndexWriter writer = new IndexWriter( directory, analyzer, true );
	Document doc = new Document();
	doc.add( new Field( FIELD, CONTENT, Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.WITH_POSITIONS_OFFSETS ) );
	writer.addDocument( doc );
	writer.close();
    }

    static void printTermFreqVector( final TermFreqVector tfv ){
	String[] ts = tfv.getTerms();
	int[] tfs = tfv.getTermFrequencies();
	for( int i = 0; i < tfv.size(); i++ ){
	    System.out.println( ts[i] + " :\t" + Integer.toString( tfs[i] ) );
	    printTermPositionVector( (TermPositionVector)tfv, i );
	}
    }

    static void printTermPositionVector( final TermPositionVector tpv, final int index ){

	int[] tps = tpv.getTermPositions( index );
	System.out.print( "\tterm positions :" );
	for( int j = 0; j < tps.length; j++ )
	    System.out.print( "\t" + Integer.toString( tps[j] ) );
	System.out.print( "\n" );

	TermVectorOffsetInfo[] tvois = tpv.getOffsets( index );
	System.out.print( "\toffsets :" );
	for( int j = 0; j < tvois.length; j++ )
	    System.out.print( "\t( " + Integer.toString( tvois[j].getStartOffset() ) + ", " + Integer.toString( tvois[j].getEndOffset() ) + " )" );
	System.out.print( "\n" );
    }
}
