package gihyo.lucene.ch6;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Hits;

public class TestThesaurus {

    static final String[] contents = {
	"Map̓C^tF[XłB",
	"Set̓C^[tFCXłB",
	"List̓C^tFCXłB",
	"Iterator̓C^[tF[XłB",
	"z邨܂B",
	"z邨܂B",
	"1K̎t܂łzB",
	"1K̎t܂łzB",
	"1K̎󂯕t܂łzB"
    };
    static final String FIELD = "F";
    static final String[] queries = {
	"C^tF[X", "z", "󂯕t"
    };
    static final Directory directory = new RAMDirectory();

    public static void main( String[] args ) throws IOException, ParseException {
	testThesaurusImpl();
	Analyzer analyzer = new JapaneseThesaurusAnalyzer( new ThesaurusImpl() );
	makeIndex( analyzer );
	searchIndex();
	directory.close();
    }

    static void makeIndex( final Analyzer analyzer ) throws IOException {
	IndexWriter writer = new IndexWriter( directory, analyzer, true );
	for( int i = 0; i < contents.length; i++ ){
	    Document doc = new Document();
	    doc.add( new Field( FIELD, contents[i], Field.Store.YES, Field.Index.TOKENIZED ) );
	    writer.addDocument( doc );
	}
	writer.close();
    }

    static void searchIndex() throws IOException, ParseException {
	IndexSearcher searcher = new IndexSearcher( directory );
	QueryParser qp = new QueryParser( FIELD, new JapaneseAnalyzer() );
	for( int i = 0; i < queries.length; i++ ){
	    System.out.println( "\n: " + queries[i] );
	    Query query = qp.parse( queries[i] );
	    Hits hits = searcher.search( query );
	    System.out.println( "qbg: " + Integer.toString( hits.length() ) + "" );
	    System.out.println( "================================" );
	    for( int j = 0; j < hits.length(); j++ ){
		Document doc = hits.doc( j );
		System.out.println( doc.get( FIELD ) );
	    }
	}
	searcher.close();
    }

    static void testThesaurusImpl(){
	Thesaurus thesaurus = new ThesaurusImpl();
	for( int i = 0; i < queries.length; i++ ){
	    String[] words = thesaurus.getGroupWords( queries[i] );
	    for( int j = 0; j < words.length; j++ )
		System.out.println( words[j] );
	}
    }
}
