package gihyo.lucene.ch6;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.util.Map;
import java.util.HashMap;

public class ThesaurusImpl implements Thesaurus {

    static String[][] groups = {
	{ "C^tF[X", "C^[tFCX", "C^tFCX", "C^[tF[X" },
	{ "z", "z" },
	{ "t", "t", "󂯕t" }
    };
    Map map;

    public ThesaurusImpl(){
	map = new HashMap();
	for( int i = 0; i < groups.length; i++ ){
	    String[] value = groups[i];
	    for( int j = 0; j < groups[i].length; j++ )
		map.put( groups[i][j], value );
	}
    }

    public String[] getGroupWords( final String word ){
	String[] value = (String[])map.get( word );
	if( value == null ) return null;
	String[] words = new String[value.length - 1];
	int i = 0;
	for( int j = 0; j < value.length; j++ ){
	    if( !value[j].equals( word ) )
		words[i++] = value[j];
	}
	return words;
    }
}
