package gihyo.lucene.ch6.ajax;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import java.util.Map;
import java.util.HashMap;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.document.Document;
import gihyo.lucene.ch3.PostIndexer;

public class IncrementalSearch {

    public static String INDEX_DIR = "c:/Project/lucene/sample/simpleapp/index-post";
    private static int LIST_MAX = 10;
    private static String KEY_LENGTH = "length";
    private static String KEY_COMPANY = "company";
    private static IndexSearcher searcher;

    public static void main( String[] args ) throws IOException {
	printResult( listCompanies( "110" ) );
	printResult( listCompanies( "11085" ) );
	printResult( listCompanies( "1108503" ) );
    }

    private static void printResult( final Map result ){
	System.out.println( (String)result.get( KEY_LENGTH ) );
	for( int i = 0; i < LIST_MAX; i++ )
	    System.out.println( (String)result.get( KEY_COMPANY + Integer.toString( i ) ) );
    }

    public static Map listCompanies( final String zip ) throws IOException {
	IndexSearcher searcher = getIndexSearcher();
	Query query = new PrefixQuery( new Term( PostIndexer.F_INDZIP, zip ) );
	Hits hits = searcher.search( query );
	Map map = new HashMap();
	int len = hits.length();
	map.put( KEY_LENGTH, "Y: " + Integer.toString( len ) + " iő10\j" );
	for( int i = 0; i < LIST_MAX; i++ ){
	    if( i < len ){
		Document doc = hits.doc( i );
		map.put( KEY_COMPANY + Integer.toString( i ),
			 getLinkString( hits.id( i ), doc ) );
	    }
	    else
		map.put( KEY_COMPANY + Integer.toString( i ), "" );
	}
	return map;
    }

    private static String getLinkString( final int docNum, final Document doc ){
	StringBuffer buf = new StringBuffer();
	buf.append( "<a href=\"/ajax/detail.jsp?doc=" );
	buf.append( Integer.toString( docNum ) );
	buf.append( "\">" );
	buf.append( doc.get( PostIndexer.F_INDZIP ) + " - " +
		    doc.get( PostIndexer.F_ADDR ) + " - " +
		    doc.get( PostIndexer.F_NAME ) );
	buf.append( "</a>" );
	return buf.toString();
    }

    private static synchronized IndexSearcher getIndexSearcher() throws IOException {
	if( searcher == null )
	    searcher = new IndexSearcher( INDEX_DIR );
	return searcher;
    }
}
