package org.cnlp.apachecon.search;

import java.util.ArrayList;
import java.util.List;

import org.apache.lucene.analysis.Token;


/**
 * Copyright 2005 Center for Natural Language Processing
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */


/**
 * Holds information from the {@link QAService} about a candidate for QA.
 *
 **/
public class QAResult
{
    private String title;
    private String candidate;
    private String url;
    private int docId;
    private int startOffset;
    private int endOffset;
    private List tokens = new ArrayList();
    private float score;

    public QAResult()
    {
    }

    public QAResult(int docId, String title, String url)
    {
        this.docId = docId;
        this.title = title;
        this.url = url;
    }

    public QAResult(int docId, String candidate, String docTitle, int startOffset, int endOffset, String url)
    {
        this.docId = docId;
        this.candidate = candidate;
        this.title = docTitle;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.url = url;
    }

    public void addToken(Token token)
    {
        tokens.add(token);
    }

    public void removeToken(Token token)
    {
        tokens.remove(token);
    }

    public List getTokens()
    {
        return tokens;
    }

    public void setTokens(List tokens)
    {
        this.tokens = tokens;
    }

    public int getDocId()
    {
        return docId;
    }

    public void setDocId(int docId)
    {
        this.docId = docId;
    }

    public String getTitle()
    {
        return title;
    }

    public void setTitle(String title)
    {
        this.title = title;
    }

    public int getEndOffset()
    {
        return endOffset;
    }

    public void setEndOffset(int endOffset)
    {
        this.endOffset = endOffset;
    }

    public float getScore()
    {
        return score;
    }

    public void setScore(float score)
    {
        this.score = score;
    }

    public int getStartOffset()
    {
        return startOffset;
    }

    public void setStartOffset(int startOffset)
    {
        this.startOffset = startOffset;
    }

    public String getUrl()
    {
        return url;
    }

    public void setUrl(String url)
    {
        this.url = url;
    }

    /**
     * The original text
     * @return The original candidate, may be different from what is reconstructed by the {@link #getTokens()}
     */
    public String getCandidate()
    {
        return candidate;
    }

    public void setCandidate(String candidate)
    {
        this.candidate = candidate;
    }
}
