package org.cnlp.apachecon.search;

/**
 * Copyright 2005 Center for Natural Language Processing
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.util.Comparator;


/**
 *
 *
 **/
public class QAResultComparator implements Comparator
{
    public int compare(Object o1, Object o2)
    {
        QAResult qa1 = (QAResult) o1;
        QAResult qa2 = (QAResult) o2;
        if (qa1.getScore() < qa2.getScore())
            return 1;		 // Neither val is NaN, thisVal is smaller
        if (qa1.getScore() > qa2.getScore())
            return -1;		 // Neither val is NaN, thisVal is larger

        int thisBits = Float.floatToIntBits(qa1.getScore());
        int anotherBits = Float.floatToIntBits(qa2.getScore());

        return (thisBits == anotherBits ?  0 : // Values are equal
                (thisBits < anotherBits ? 1 : // (-0.0, 0.0) or (!NaN, NaN)
                 -1));                          // (0.0, -0.0) or (NaN, !NaN)
    }
}
