package nayami.config;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DocumentIteratorConfig {

    private String className;
    private Properties properties = new Properties();

    private static Log log = LogFactory.getLog( DocumentIteratorConfig.class );

    public void setClassName( String className ){
	this.className = className;
	log.debug( "className: " + className );
    }
    public String getClassName(){
	return className;
    }

    public void addProperty( String name, String value ){
	properties.setProperty( name, value );
	log.debug( "property name: " + name + ", value: " + value );
    }
    public Properties getProperties(){
	return properties;
    }
    public String getProperty( String name ){
	return getProperty( name );
    }
}
