package nayami.config;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NayamiConfig {

    private String indexDirectory;
    private String analyzerClassName;
    private String bookDirectory;
    private String bookDigesterRules;
    private List sourceIterators = new ArrayList();
    private List documentIterators = new ArrayList();
    private int pageSize;

    private static Log log = LogFactory.getLog( NayamiConfig.class );

    public void setIndexDirectory( String indexDirectory ){
	this.indexDirectory = indexDirectory;
	log.debug( "indexDirectory: " + indexDirectory );
    }
    public String getIndexDirectory(){
	return indexDirectory;
    }

    public void setAnalyzerClassName( String analyzerClassName ){
	this.analyzerClassName = analyzerClassName;
	log.debug( "analyzerClassName: " + analyzerClassName );
    }
    public String getAnalyzerClassName(){
	return analyzerClassName;
    }

    public void setBookDirectory( String bookDirectory ){
	this.bookDirectory = bookDirectory;
	log.debug( "bookDirectory: " + bookDirectory );
    }
    public String getBookDirectory(){
	return bookDirectory;
    }

    public void setBookDigesterRules( String bookDigesterRules ){
	this.bookDigesterRules = bookDigesterRules;
	log.debug( "bookDigesterRules: " + bookDigesterRules );
    }
    public String getBookDigesterRules(){
	return bookDigesterRules;
    }

    public void addSourceIterator( SourceIteratorConfig iterator ){
	sourceIterators.add( iterator );
    }
    public List getSourceIterators(){
	return sourceIterators;
    }

    public void addDocumentIterator( DocumentIteratorConfig iterator ){
	documentIterators.add( iterator );
    }
    public List getDocumentIterators(){
	return documentIterators;
    }

    public void setPageSize( int pageSize ){
	this.pageSize = pageSize;
    }
    public int getPageSize(){
	return pageSize;
    }
}
