package nayami.indexer;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DateTools;
import nayami.constant.DocumentFields;

public abstract class AbstractFileDocumentIterator implements DocumentIterator {

    private static Log log = LogFactory.getLog( AbstractFileDocumentIterator.class );

    private static final String PROP_DIRECTORY = "directory";
    protected Properties properties = new Properties();
    private IndexReader reader;
    private Iterator iterator = null;

    public void setProperty( String name, String value ){
	properties.setProperty( name, value );
    }

    public void setIndexReader( IndexReader reader ) throws IOException {
	this.reader = reader;
	iterator = getDeleteFiles( properties.getProperty( PROP_DIRECTORY ) ).iterator();
    }

    public boolean hasNext(){
	return iterator.hasNext();
    }

    public int next(){
	Integer i = (Integer)iterator.next();
	return i.intValue();
    }

    protected abstract String getDocumentType();

    protected List getDeleteFiles( String directory ) throws IOException {
	IndexSearcher searcher = new IndexSearcher( reader );
	Hits hits = searcher.search( new TermQuery( new Term( DocumentFields.TYPE, getDocumentType() ) ) );
	List delList = new ArrayList();
	int len = hits.length();
	for( int i = 0; i < len; i++ ){
	    Document doc = hits.doc( i );
	    File file = getFile( directory, doc );
	    if( isModified( doc, file ) )
		delList.add( new Integer( hits.id( i ) ) );
	}
	searcher.close();
	return delList;
    }

    protected File getFile( String directory, Document doc ){
	return new File( directory, doc.get( DocumentFields.ID ) );
    }

    private boolean isModified( Document doc, File file ){
	if( !file.exists() ){
	    log.info( "hLg͍폜Ă܂B" );
	    return true;
	}
	String docDate = doc.get( DocumentFields.DATE );
	String fileDate = DateTools.timeToString( file.lastModified(),
						  DateTools.Resolution.MILLISECOND );
	log.debug( "docDate = " + docDate +
		   ", fileDate = " + fileDate );
	if( docDate.compareTo( fileDate ) < 0 ){
	    log.info( "hLg͍XVĂ܂B" );
	    return true;
	}
	log.debug( "hLg͍XVĂ܂B" );
	return false;
    }
}
