package nayami.indexer;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractFileSourceIterator extends AbstractSourceIterator {

    private static Log log = LogFactory.getLog( AbstractFileSourceIterator.class );

    private static final String PROP_URL_PREFIX = "url.prefix";
    private static final String PROP_DIRECTORY = "directory";
    protected Properties properties = new Properties();
    private String fileExtension;
    private Iterator iterator = null;

    public void setProperty( String name, String value ){
	properties.setProperty( name, value );
    }

    protected String getUrlPrefix(){
	return properties.getProperty( PROP_URL_PREFIX );
    }

    protected Iterator getIterator(){
	if( iterator == null ){
	    String directory = properties.getProperty( PROP_DIRECTORY );
	    iterator = getAllFiles( getFileExtension(), directory ).iterator();
	}
	return iterator;
    }

    protected abstract String getFileExtension();

    protected List getAllFiles( String extension, String dirStr ){
	List files = new ArrayList();
	File dir = new File( dirStr );
	if( !dir.exists() || !dir.isDirectory() ){
	    log.error( dirStr + " is not a directory." );
	    return files;
	}
	fileExtension = extension;
	listFiles( files, new String(), dir );
	return files;
    }

    protected void listFiles( List files, String relativePath, File dir ){
	File[] fileArray = dir.listFiles();
	String[] fa = dir.list();
	for( int i = 0; i < fileArray.length; i++ ){
	    File f = fileArray[i];
	    if( !f.isDirectory() ){
		if( f.getName().endsWith( fileExtension ) )
		    files.add( new RelativeFile( relativePath, f ) );
	    }
	    else
		listFiles( files,
			   new String( relativePath + fa[i] + System.getProperty( "file.separator" ) ),
			   fileArray[i] );
	}
    }

    static class RelativeFile {
	private String relativePath;
	private File file;
	RelativeFile( String relativePath, File file ){
	    this.relativePath = relativePath;
	    this.file = file;
	}
	String getRelativePath(){
	    return relativePath;
	}
	File getFile(){
	    return file;
	}
	String getRelativeFilePath(){
	    return relativePath + file.getName();
	}
    }
}
