package nayami.indexer;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.xml.sax.SAXException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.analysis.Analyzer;
import nayami.config.NayamiConfig;

public abstract class AbstractIndexer {

    private static Log log = LogFactory.getLog( AbstractIndexer.class );
    protected NayamiConfig nayamiConfig = null;
    protected Analyzer analyzer = null;

    protected AbstractIndexer( String digesterRules, String config ){
	nayamiConfig = getNayamiConfig( digesterRules, config );
    }

    private NayamiConfig getNayamiConfig( String digesterRules, String config ){
	NayamiConfig nayamiConfig = null;
	try{
	    ClassLoader cl = getClass().getClassLoader();
	    Digester digester = DigesterLoader.createDigester( cl.getResource( digesterRules ) );
	    nayamiConfig = (NayamiConfig)digester.parse( cl.getResourceAsStream( config ) );
	}
	catch( IOException e ){
	    abend( e.toString() );
	}
	catch( SAXException e ){
	    abend( e.toString() );
	}
	return nayamiConfig;
    }

    protected IndexWriter getIndexWriter( boolean create ){
	IndexWriter writer = null;
	try{
	    writer = new IndexWriter( getPath(), getAnalyzer(), create );
	}
	catch( IOException e ){
	    abend( e.toString() );
	}
	return writer;
    }

    protected String getPath(){
	String directory = nayamiConfig.getIndexDirectory();
	log.info( "CfbNXfBNg: " + directory );
	return directory;
    }

    protected Analyzer getAnalyzer(){
	if( analyzer == null ){
	    try{
		String className = nayamiConfig.getAnalyzerClassName();
		log.info( "Analyzer " + className + " [h܂B" );
		ClassLoader cl = getClass().getClassLoader();
		analyzer = (Analyzer)cl.loadClass( className ).newInstance();
	    }
	    catch( ClassNotFoundException e ){
		abend( e.toString() );
	    }
	    catch( InstantiationException e ){
		abend( e.toString() );
	    }
	    catch( IllegalAccessException e ){
		abend( e.toString() );
	    }
	}
	return analyzer;
    }

    protected void abend( String error ){
	log.fatal( error );
	log.error( "CłȂG[܂BvOI܂B" );
	System.exit( 1 );
    }
}
