package nayami.indexer;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.DateTools;
import nayami.constant.DocumentFields;

public abstract class AbstractSourceIterator implements SourceIterator {

    private static Log log = LogFactory.getLog( AbstractSourceIterator.class );

    protected Field getIdField( int id ){
	return getIdField( Integer.toString( id ) );
    }

    protected Field getIdField( String id ){
	return new Field( DocumentFields.ID, id, Field.Store.YES, Field.Index.UN_TOKENIZED );
    }

    protected Field getDateField( Date date ){
	return getDateField( DateTools.dateToString( date, DateTools.Resolution.MILLISECOND ) );
    }

    protected Field getDateField( long time ){
	return getDateField( DateTools.timeToString( time, DateTools.Resolution.MILLISECOND ) );
    }

    protected Field getDateField( String date ){
	return new Field( DocumentFields.DATE, date, Field.Store.YES, Field.Index.UN_TOKENIZED );
    }

    protected Field getTypeField( String type ){
	return new Field( DocumentFields.TYPE, type, Field.Store.YES, Field.Index.UN_TOKENIZED );
    }

    protected Field getUrlField( String url ){
	return new Field( DocumentFields.URL, url, Field.Store.YES, Field.Index.NO );
    }

    protected Field getTitleField( String title ){
	return new Field( DocumentFields.TITLE, title, Field.Store.YES, Field.Index.TOKENIZED );
    }

    protected Field getContentField( String content ){
	return new Field( DocumentFields.CONTENT, content, Field.Store.NO, Field.Index.TOKENIZED );
    }

    protected Field getOwnerField( String owner ){
	return new Field( DocumentFields.OWNER, owner, Field.Store.YES, Field.Index.UN_TOKENIZED );
    }
}
