package nayami.indexer;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import java.io.File;
import java.io.InputStream;
import java.io.FileInputStream;
import java.util.Iterator;
import org.xml.sax.SAXException;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import nayami.model.BookInfo;
import nayami.constant.DocumentTypes;

public class BookSourceIterator extends AbstractFileSourceIterator {

    private static Log log = LogFactory.getLog( BookSourceIterator.class );

    private static final String PROP_DIGESTER_RULES = "digester.rules";
    private static final String FILE_EXTENSION = ".xml";
    private Digester digester = null;

    private String getDigesterRules(){
	return properties.getProperty( PROP_DIGESTER_RULES );
    }

    protected String getFileExtension(){
	return FILE_EXTENSION;
    }

    public boolean hasNext(){
	return getIterator().hasNext();
    }

    public Document next(){
	Document doc = new Document();
	RelativeFile rf = (RelativeFile)getIterator().next();
	doc.add( getIdField( rf.getRelativeFilePath() ) );
	doc.add( getDateField( rf.getFile().lastModified() ) );
	doc.add( getTypeField( DocumentTypes.BOOK ) );
	doc.add( getUrlField( getUrlPrefix() +
			      rf.getRelativePath() +
			      rf.getFile().getName() ) );
	BookInfo bookInfo = getBookInfo( rf.getFile() );
	if( bookInfo == null )
	    return null;
	String publisher = bookInfo.getPublisher();
	String category = bookInfo.getCategory();
	String title = bookInfo.getTitle();
	String author = bookInfo.getAuthor();
	String summary = bookInfo.getSummary();
	String content = publisher + " " +
	    category + " " +
	    title + " " +
	    author + " " +
	    summary;
	doc.add( getTitleField( title ) );
	doc.add( getContentField( content ) );
	return doc;
    }

    private BookInfo getBookInfo( File file ){
	BookInfo bi = null;
	try{
	    bi = (BookInfo)getDigester().parse( new FileInputStream( file ) );
	}
	catch( IOException e ){
	    log.error( e.toString() );
	}
	catch( SAXException e ){
	    log.error( e.toString() );
	}
	return bi;
    }

    private Digester getDigester(){
	if( digester == null ){
	    ClassLoader cl = getClass().getClassLoader();
	    digester = DigesterLoader.createDigester( cl.getResource( getDigesterRules() ) );
	}
	return digester;
    }
}
