package nayami.indexer;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DateTools;
import org.hibernate.HibernateException;
import nayami.model.dao.BasicSessionManager;
import nayami.model.Bulletin;
import nayami.model.dao.BulletinDAO;
import nayami.constant.DocumentTypes;
import nayami.constant.DocumentFields;

public class BulletinDocumentIterator implements DocumentIterator {

    private static Log log = LogFactory.getLog( BulletinDocumentIterator.class );

    private IndexReader reader;
    private Iterator iterator;
    private BulletinDAO bulletinDAO;

    public BulletinDocumentIterator(){
	bulletinDAO = new BulletinDAO( new BasicSessionManager().getSession() );
    }

    public void setProperty( String name, String value ){}

    public void setIndexReader( IndexReader reader ) throws IOException {
	this.reader = reader;
	iterator = getDeleteBulletins().iterator();
    }

    public boolean hasNext(){
	return iterator.hasNext();
    }

    public int next(){
	Integer i = (Integer)iterator.next();
	return i.intValue();
    }

    protected List getDeleteBulletins() throws IOException {
	IndexSearcher searcher = new IndexSearcher( reader );
	Hits hits = searcher.search( new TermQuery( new Term( DocumentFields.TYPE, DocumentTypes.BULLETIN ) ) );
	List delList = new ArrayList();
	int len = hits.length();
	try{
	    for( int i = 0; i < len; i++ ){
		Document doc = hits.doc( i );
		Bulletin bulletin = getBulletin( doc.get( DocumentFields.ID ) );
		if( isModified( doc, bulletin ) )
		    delList.add( new Integer( hits.id( i ) ) );
	    }
	}
	catch( HibernateException e ){
	    log.error( e.toString() );
	}
	finally{
	    searcher.close();
	}
	return delList;
    }

    protected Bulletin getBulletin( String strId ) throws HibernateException {
	int id = Integer.parseInt( strId );
	return bulletinDAO.findByPrimaryKey( id );
    }

    private boolean isModified( Document doc, Bulletin bulletin ){
	if( bulletin == null ){
	    log.debug( "hLg͍폜Ă܂B" );
	    return true;
	}
	String docDate = doc.get( DocumentFields.DATE );
	String bltnDate = DateTools.dateToString( bulletin.getModifyDate(),
						  DateTools.Resolution.MILLISECOND );
	log.debug( "docDate = " + docDate +
		   ", bltnDate = " + bltnDate );
	if( docDate.compareTo( bltnDate ) < 0 ){
	    log.debug( "hLg͍XVĂ܂B" );
	    return true;
	}
	log.debug( "hLg͍XVĂ܂B" );
	return false;
    }
}
