package nayami.indexer;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.util.ArrayList;
import java.util.List;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.hibernate.HibernateException;
import nayami.model.dao.BasicSessionManager;
import nayami.model.Bulletin;
import nayami.model.dao.BulletinDAO;
import nayami.constant.DocumentTypes;

public class BulletinSourceIterator extends AbstractSourceIterator {

    private static Log log = LogFactory.getLog( BulletinSourceIterator.class );

    private static final String PROP_URL_PREFIX = "url.prefix";
    private Properties properties = new Properties();
    private Iterator iterator;

    BulletinSourceIterator(){
	iterator = getAllBulletins().iterator();
    }

    public void setProperty( String name, String value ){
	properties.setProperty( name, value );
    }

    protected String getUrlPrefix(){
	return properties.getProperty( PROP_URL_PREFIX );
    }

    public boolean hasNext(){
	return iterator.hasNext();
    }

    public Document next(){
	Document doc = new Document();
	Bulletin bulletin = (Bulletin)iterator.next();
	doc.add( getIdField( bulletin.getId() ) );
	doc.add( getDateField( bulletin.getModifyDate() ) );
	doc.add( getTypeField( DocumentTypes.BULLETIN ) );
	doc.add( getUrlField( getUrlPrefix() +
			      Integer.toString( bulletin.getId() ) ) );
	doc.add( getTitleField( bulletin.getQuestion() ) );
	doc.add( getContentField( bulletin.getQuestion() +
				  bulletin.getAnswer() ) );
	doc.add( getOwnerField( bulletin.getQuestioner() ) );
	return doc;
    }

    protected List getAllBulletins(){
	try{
	    BulletinDAO bulletinDAO = new BulletinDAO( new BasicSessionManager().getSession() );
	    return bulletinDAO.findAll();
	}
	catch( HibernateException e ){
	    log.error( "cannot get bulletins. error = " + e.toString() );
	    return new ArrayList();
	}
    }
}
