package nayami.indexer;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import java.util.Properties;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import nayami.config.DocumentIteratorConfig;

public interface DocumentIterator {

    public void setProperty( String name, String value );
    public void setIndexReader( IndexReader reader ) throws IOException;
    public boolean hasNext();
    public int next();

    public static class DocumentIteratorFactory {

	private static Log log = LogFactory.getLog( DocumentIteratorFactory.class );
	public static DocumentIterator getDocumentIterator( DocumentIteratorConfig dic, IndexReader reader ) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
	    String className = dic.getClassName();
	    log.debug( "DocumentIterator " + className + " [h܂B" );
	    DocumentIterator di = (DocumentIterator)Class.forName( className ).newInstance();
	    Properties properties = dic.getProperties();
	    Enumeration e = properties.propertyNames();
	    while( e.hasMoreElements() ){
		String name = (String)e.nextElement();
		String value = properties.getProperty( name );
		di.setProperty( name, value );
	    }
	    di.setIndexReader( reader );
	    return di;
	}
    }
}
