package nayami.indexer;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import java.util.List;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.document.Document;
import nayami.config.SourceIteratorConfig;

public class MakeIndex extends AbstractIndexer {

    private static Log log = LogFactory.getLog( MakeIndex.class );

    public static void main( String args[] ){

	if( args.length != 2 )
	    printUsage();

	log.info( "CfbNX쐬܂B" );
	MakeIndex indexer = getInstance( args[0], args[1] );
	indexer.makeIndex();
	log.info( "CfbNX̍쐬I܂B" );
    }

    private static void printUsage(){
	System.out.println( "g: MakeIndex <Digester Rules File> <Config File>" );
	System.exit( 1 );
    }

    public static MakeIndex getInstance( String digesterRules, String config ){
	return new MakeIndex( digesterRules, config );
    }

    private MakeIndex( String digesterRules, String config ){
	super( digesterRules, config );
    }

    private void makeIndex(){
	IndexWriter writer = getIndexWriter( true );
	List siList = nayamiConfig.getSourceIterators();
	try{
	    for( Iterator sii = siList.iterator(); sii.hasNext(); ){
		SourceIteratorConfig sic = (SourceIteratorConfig)sii.next();
		log.info( sic.getClassName() + " ܂B" );
		SourceIterator si = SourceIterator.SourceIteratorFactory.getSourceIterator( sic );
		while( si.hasNext() ){
		    Document doc = si.next();
		    if( doc != null ){
			writer.addDocument( doc );
			log.debug( "hLgo^܂B" );
		    }
		}
	    }
	    log.info( "CfbNX̍œKĂ܂B" );
	    writer.optimize();
	    log.info( "CfbNX̍œKI܂B" );
	}
	catch( IOException e ){
	    abend( e.toString() );
	}
	catch( ClassNotFoundException e ){
	    abend( e.toString() );
	}
	catch( InstantiationException e ){
	    abend( e.toString() );
	}
	catch( IllegalAccessException e ){
	    abend( e.toString() );
	}
	finally{
	    if( writer != null ){
		try{
		    writer.close();
		}
		catch( IOException ignore ){}
	    }
	}
    }
}
