package nayami.indexer;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import java.util.List;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BooleanClause;
import nayami.config.DocumentIteratorConfig;
import nayami.config.SourceIteratorConfig;
import nayami.constant.DocumentFields;

public class UpdateIndex extends AbstractIndexer {

    private static Log log = LogFactory.getLog( UpdateIndex.class );

    public static void main( String args[] ){

	if( args.length != 2 )
	    printUsage();

	log.info( "CfbNXXV܂B" );
	UpdateIndex indexer = getInstance( args[0], args[1] );
	log.debug( "hLg폜܂B" );
	indexer.deleteDocuments();
	log.debug( "hLgǉ܂B" );
	indexer.addDocuments();
	log.info( "CfbNX̍XVI܂B" );
    }

    private static void printUsage(){
	System.out.println( "g: UpdateIndex <Digester Rules File> <Config File>" );
	System.exit( 1 );
    }

    public static UpdateIndex getInstance( String digesterRules, String config ){
	return new UpdateIndex( digesterRules, config );
    }

    private UpdateIndex( String digesterRules, String config ){
	super( digesterRules, config );
    }

    private void deleteDocuments(){
	IndexReader reader = getIndexReader();
	List diList = nayamiConfig.getDocumentIterators();
	try{
	    for( Iterator dii = diList.iterator(); dii.hasNext(); ){
		DocumentIteratorConfig dic = (DocumentIteratorConfig)dii.next();
		log.debug( dic.getClassName() + " ܂B" );
		DocumentIterator di = DocumentIterator.DocumentIteratorFactory.getDocumentIterator( dic, reader );
		while( di.hasNext() ){
		    int id = di.next();
		    log.info( "hLg id = " + Integer.toString( id ) +
			      " 폜܂B" );
		    reader.deleteDocument( id );
		}
	    }
	}
	catch( IOException e ){
	    abend( e.toString() );
	}
	catch( ClassNotFoundException e ){
	    abend( e.toString() );
	}
	catch( InstantiationException e ){
	    abend( e.toString() );
	}
	catch( IllegalAccessException e ){
	    abend( e.toString() );
	}
	finally{
	    if( reader != null ){
		try{
		    reader.close();
		}
		catch( IOException ignore ){}
	    }
	}
    }

    private void addDocuments(){
	IndexWriter writer = getIndexWriter( false );
	IndexSearcher searcher = getIndexSearcher();
	List siList = nayamiConfig.getSourceIterators();
	try{
	    for( Iterator sii = siList.iterator(); sii.hasNext(); ){
		SourceIteratorConfig sic = (SourceIteratorConfig)sii.next();
		log.debug( sic.getClassName() + " ܂B" );
		SourceIterator si = SourceIterator.SourceIteratorFactory.getSourceIterator( sic );
		while( si.hasNext() ){
		    Document doc = si.next();
		    if( doc != null )
			addDocument( writer, searcher, doc );
		}
	    }
	    log.info( "CfbNX̍œKĂ܂B" );
	    writer.optimize();
	    log.info( "CfbNX̍œKI܂B" );
	}
	catch( InvalidIndexException e ){
	    abend( e.toString() );
	}
	catch( IOException e ){
	    abend( e.toString() );
	}
	catch( ClassNotFoundException e ){
	    abend( e.toString() );
	}
	catch( InstantiationException e ){
	    abend( e.toString() );
	}
	catch( IllegalAccessException e ){
	    abend( e.toString() );
	}
	finally{
	    if( searcher != null ){
		try{
		    searcher.close();
		}
		catch( IOException ignore ){}
	    }
	    if( writer != null ){
		try{
		    writer.close();
		}
		catch( IOException ignore ){}
	    }
	}
    }

    private void addDocument( IndexWriter writer,
			      IndexSearcher searcher,
			      Document doc )
	throws InvalidIndexException, IOException {
	String id = doc.get( DocumentFields.ID );
	String type = doc.get( DocumentFields.TYPE );
	BooleanQuery bq = new BooleanQuery();
	bq.add( new TermQuery( new Term( DocumentFields.ID, id ) ),
		BooleanClause.Occur.MUST );
	bq.add( new TermQuery( new Term( DocumentFields.TYPE, type ) ),
		BooleanClause.Occur.MUST );
	Hits hits = searcher.search( bq );
	if( hits.length() == 0 ){
	    log.info( "hLg id = " + id +
		      ", type = " + type +
		      " ǉ܂B" );
	    writer.addDocument( doc );
	}
	else if( hits.length() == 1 )
	    log.debug( "hLg id = " + id +
		       ", type = " + type +
		       " ͍XVĂ܂B" );
	else
	    throw new InvalidIndexException( "CfbNX͐쐬Ă܂B" );
    }

    protected IndexReader getIndexReader(){
	IndexReader reader = null;
	try{
	    reader = IndexReader.open( getPath() );
	}
	catch( IOException e ){
	    abend( e.toString() );
	}
	return reader;
    }

    protected IndexSearcher getIndexSearcher(){
	IndexSearcher searcher = null;
	try{
	    searcher = new IndexSearcher( getPath() );
	}
	catch( IOException e ){
	    abend( e.toString() );
	}
	return searcher;
    }
}
