package nayami.junit.model;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import junit.framework.TestCase;
import nayami.model.Bulletin;

public class BulletinTestCase extends TestCase {

    private static Log log = LogFactory.getLog( BulletinTestCase.class );

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testSetGetQuestioner() throws Exception {
	final String questioner = "Җ";
	Bulletin bulletin = new Bulletin();
	bulletin.setQuestioner( questioner );
	assertEquals( bulletin.getQuestioner(), questioner );
    }

    public void testSetGetQuestion() throws Exception {
	final String question = "e";
	Bulletin bulletin = new Bulletin();
	bulletin.setQuestion( question );
	assertEquals( bulletin.getQuestion(), question );
    }

    public void testSetGetAnswer() throws Exception {
	final String answer = "񓚓e";
	Bulletin bulletin = new Bulletin();
	bulletin.setAnswer( answer );
	assertEquals( bulletin.getAnswer(), answer );
    }

    public void testSetIsAnswered() throws Exception {
	Bulletin bulletin = new Bulletin();
	assertFalse( bulletin.isAnswered() );
	bulletin.setAnswered( true );
	assertTrue( bulletin.isAnswered() );
    }

    public void testEquals() throws Exception {
	// Bulletin쐬
	Bulletin bulletin1 = newBulletin();
	Bulletin bulletin2 = newBulletin();

	// r
	assertEquals( bulletin1, bulletin2 );
    }

    public void testEqualsNotEqual() throws Exception {
	// Bulletin쐬
	Bulletin bulletin1 = newBulletin();
	Bulletin bulletin2 = newBulletin2();

	// r
	assertNotSame( bulletin1, bulletin2 );
    }

    public void testEqualsNotEqual2() throws Exception {
	// Bulletin쐬
	Bulletin bulletin1 = newBulletin();
	Bulletin bulletin2 = null;

	// r
	assertFalse( bulletin1.equals( bulletin2 ) );
    }

    public void testHashCode() throws Exception {
	// BulletiñnbVR[h擾
	int hash1 = newBulletin().hashCode();
	int hash2 = newBulletin().hashCode();

	// r
	assertTrue( hash1 == hash2 );

	// \
	log.info( "  hash code of Bulletin1 is " + hash1 );
    }

    public void testHashCode2() throws Exception {
	// BulletiñnbVR[h擾
	int hash1 = newBulletin().hashCode();
	int hash2 = newBulletin2().hashCode();

	// r
	assertFalse( hash1 == hash2 );

	// \
	log.info( "  hash code of Bulletin2 is " + hash2 );
    }

    public void testToString() throws Exception {
	// Bulletin̕\擾
	String str1 = newBulletin().toString();

	// \
	log.info( "  toString of Bulletin1 is " + str1 );
    }

    private Bulletin newBulletin(){
	return newBulletin( 1, "", "ɂ͎₪܂",
			    null, false,
			    new Date( 0 ), new Date( 0 ) );
    }

    private Bulletin newBulletin2(){
	return newBulletin( 2, "", "ɂ͎₪܂",
			    "ɂ͉񓚂܂", true,
			    new Date( 0 ), new Date( 0 ) );
    }

    private Bulletin newBulletin( int id, String questioner, String question,
				  String answer, boolean answered,
				  Date createDate, Date modifyDate ){
	Bulletin bulletin = new Bulletin();
	bulletin.setId( id );
	bulletin.setQuestioner( questioner );
	bulletin.setQuestion( question );
	bulletin.setAnswer( answer );
	bulletin.setAnswered( answered );
	bulletin.setCreateDate( createDate );
	bulletin.setModifyDate( modifyDate );
	return bulletin;
    }
}
