package nayami.junit.model.dao;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import junit.framework.TestCase;
import nayami.model.Bulletin;
import nayami.model.dao.BasicSessionManager;
import nayami.model.dao.BulletinDAO;

public class BulletinDAOTestCase extends TestCase {

    private static Log log = LogFactory.getLog( BulletinDAOTestCase.class );
    private Session session = null;
    private BulletinDAO bulletinDAO = null;

    protected void setUp() throws Exception {
	session = new BasicSessionManager().getSession();
	bulletinDAO = new BulletinDAO( session );
    }

    protected void tearDown() throws Exception {
	session.close();
    }

    public void testCreateSaveDelete() throws Exception {
	// Bulletin쐬
	Bulletin bulletin = newBulletin();
	// Bulletinۑ
	bulletinDAO.save( bulletin );
	// Bulletin폜
	bulletinDAO.delete( bulletin );
    }

    public void testCreateSaveUpdateDelete() throws Exception {
	// Bulletin쐬
	Bulletin bulletin = newBulletin();
	// Bulletinۑ
	bulletinDAO.save( bulletin );
	// BulletinXV
	final String answer = "񓚂P";
	bulletin.setAnswer( answer );
	bulletin.setAnswered( true );
	bulletinDAO.update( bulletin );
	// Bulletin擾
	Bulletin bulletin2 = bulletinDAO.findByPrimaryKey( bulletin.getId() );
	assertEquals( bulletin2.getAnswer(), answer );
	assertTrue( bulletin2.isAnswered() );
	// Bulletin폜
	bulletinDAO.delete( bulletin );
    }

    public void testFindByPrimaryKey() throws Exception {
	// Bulletin쐬
	Bulletin bulletin1 = newBulletin();
	// Bulletinۑ
	bulletinDAO.save( bulletin1 );
	log.info( "  bulletin1 = " + bulletin1 );
	// Bulletin
	Bulletin bulletin2 = bulletinDAO.findByPrimaryKey( bulletin1.getId() );
	log.info( "  bulletin2 = " + bulletin2 );
	// r
	assertTrue( bulletin1.equals( bulletin2 ) );
	// Bulletin폜
	bulletinDAO.delete( bulletin1 );
    }

    public void testFindByPrimaryKeyNoBulletin() throws Exception {
	// Bulletin
	Bulletin bulletin = bulletinDAO.findByPrimaryKey( -1 );
	assertNull( bulletin );
    }

    public void testFindByQuestioner() throws Exception {
	// Bulletin쐬
	Bulletin bulletin1 = newBulletin();
	// Bulletinۑ
	bulletinDAO.save( bulletin1 );
	log.info( "  bulletin1 = " + bulletin1 );
	// Bulletin
	List list = bulletinDAO.findByQuestioner( bulletin1.getQuestioner() );
	assertTrue( list.size() == 1 );
	Bulletin bulletin2 = (Bulletin)list.get( 0 );
	log.info( "  bulletin2 = " + bulletin2 );
	// r
	assertTrue( bulletin1.equals( bulletin2 ) );
	// Bulletin폜
	bulletinDAO.delete( bulletin1 );
    }

    public void testFindByQuestioner2() throws Exception {
	// Bulletin쐬
	Bulletin bulletin1 = newBulletin();
	Bulletin bulletin2 = newBulletin3();
	// Bulletinۑ
	bulletinDAO.save( bulletin1 );
	log.info( "  bulletin1 = " + bulletin1 );
	bulletinDAO.save( bulletin2 );
	log.info( "  bulletin2 = " + bulletin2 );
	// Bulletin
	List list = bulletinDAO.findByQuestioner( bulletin1.getQuestioner() );
	assertTrue( list.size() == 2 );
	Bulletin bulletin3 = (Bulletin)list.get( 0 );
	log.info( "  bulletin3 = " + bulletin3 );
	Bulletin bulletin4 = (Bulletin)list.get( 1 );
	log.info( "  bulletin4 = " + bulletin4 );
	// r
	assertTrue( bulletin1.equals( bulletin3 ) );
	assertTrue( bulletin2.equals( bulletin4 ) );
	// Bulletin폜
	bulletinDAO.delete( bulletin1 );
	bulletinDAO.delete( bulletin2 );
    }

    public void testFindByQuestionerNoBulletin() throws Exception {
	// Bulletin
	List list = bulletinDAO.findByQuestioner( "bulletin100" );
	assertTrue( list.size() == 0 );
    }

    public void testFindAll() throws Exception {
	// Bulletin쐬
	Bulletin bulletin1 = newBulletin();
	Bulletin bulletin2 = newBulletin2();
	// Bulletinۑ
	bulletinDAO.save( bulletin1 );
	log.info( "  bulletin1 = " + bulletin1 );
	bulletinDAO.save( bulletin2 );
	log.info( "  bulletin2 = " + bulletin2 );
	// Bulletin
	List bulletins = bulletinDAO.findAll();
	log.info( "  size of bulletin list = " + bulletins.size() );
	assertEquals( bulletins.size(), 2 );
	// r
	Bulletin bulletin3 = (Bulletin)bulletins.get( 0 );
	Bulletin bulletin4 = (Bulletin)bulletins.get( 1 );
	assertEquals( bulletin1, bulletin3 );
	assertEquals( bulletin2, bulletin4 );
	// Bulletin폜
	bulletinDAO.delete( bulletin1 );
	bulletinDAO.delete( bulletin2 );
    }

    public void testFindAllNoBulletin() throws Exception {
	// Bulletin
	List bulletins = bulletinDAO.findAll();
	log.info( "  size of bulletin list = " + bulletins.size() );
	assertEquals( bulletins.size(), 0 );
    }

    private Bulletin newBulletin(){
	return newBulletin( "", "P", null, false );
    }

    private Bulletin newBulletin2(){
	return newBulletin( "", "Q", "񓚂Q", true );
    }

    private Bulletin newBulletin3(){
	return newBulletin( "", "R", "񓚂R", true );
    }

    private Bulletin newBulletin( String questioner,
				  String question,
				  String answer,
				  boolean answered ){
	Bulletin bulletin = new Bulletin();
	bulletin.setQuestioner( questioner );
	bulletin.setQuestion( question );
	bulletin.setAnswer( answer );
	bulletin.setAnswered( answered );
	return bulletin;
    }
}
