package nayami.model;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.util.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @hibernate.class
 *  table="BULLETIN"
 */
public class Bulletin {

    private int id;
    private String questioner;
    private String question;
    private String answer;
    private boolean answered;
    private Date createDate;
    private Date modifyDate;

    /**
     * @hibernate.id
     *  column="ID"
     *  generator-class="native"
     */
    public int getId(){
	return id;
    }
    public void setId( int id ){
	this.id = id;
    }

    /**
     * @hibernate.property
     *  column="QUESTIONER"
     *  length="64" not-null="true"
     */
    public String getQuestioner(){
	return questioner;
    }
    public void setQuestioner( String questioner ){
	this.questioner = questioner;
    }

    /**
     * @hibernate.property
     *  column="QUESTION"
     *  length="2048" not-null="true"
     */
    public String getQuestion(){
	return question;
    }
    public void setQuestion( String question ){
	this.question = question;
    }

    /**
     * @hibernate.property
     *  column="ANSWER"
     *  length="2048"
     */
    public String getAnswer(){
	return answer;
    }
    public void setAnswer( String answer ){
	this.answer = answer;
    }

    /**
     * @hibernate.property
     *  column="ANSWERED"
     */
    public boolean isAnswered(){
	return answered;
    }
    public void setAnswered( boolean answered ){
	this.answered = answered;
    }

    /**
     * @hibernate.property
     *  column="CREATE_DATE"
     */
    public Date getCreateDate(){
	return createDate;
    }
    public void setCreateDate( Date createDate ){
	this.createDate = createDate;
    }

    /**
     * @hibernate.property
     *  column="MODIFY_DATE"
     */
    public Date getModifyDate(){
	return modifyDate;
    }
    public void setModifyDate( Date modifyDate ){
	this.modifyDate = modifyDate;
    }

    public boolean equals( Object other ){
	if( !( other instanceof Bulletin ) ) return false;
	final Bulletin o = (Bulletin)other;
	return new EqualsBuilder()
	    .append( id, o.id )
	    .append( questioner, o.questioner )
	    .append( question, o.question )
	    .append( answer, o.answer )
	    .append( answered, o.answered )
	    .append( createDate, o.createDate )
	    .append( modifyDate, o.modifyDate )
	    .isEquals();
    }

    public int hashCode(){
	return new HashCodeBuilder( 13, 509 )
	    .append( id )
	    .append( questioner )
	    .append( question )
	    .append( answer )
	    .append( answered )
	    .append( getDateString( createDate ) )
	    .append( getDateString( modifyDate ) )
	    .toHashCode();
    }

    public String toString(){
	return new ToStringBuilder( this )
	    .append( "id", id )
	    .append( "questioner", questioner )
	    .append( "question", question )
	    .append( "answer", answer )
	    .append( "answered", answered )
	    .append( "createDate", getDateString( createDate ) )
	    .append( "modifyDate", getDateString( modifyDate ) )
	    .toString();
    }

    protected String getDateString( Date date ){
	if( date == null ) return "null";
	DateFormat df = new SimpleDateFormat( "yyyy/MM/dd HH:mm:ss.SSS" );
	return df.format( date );
    }
}
