package nayami.model.dao;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;

public class BasicSessionManager {

    private static SessionFactory sessionFactory = null;

    static synchronized SessionFactory getSessionFactory()
	throws HibernateException {
	if( sessionFactory == null ){
	    Configuration cfg = new Configuration();
	    cfg.configure();
	    sessionFactory = cfg.buildSessionFactory();
	}
	return sessionFactory;
    }

    public Session getSession() throws HibernateException {
	SessionFactory sf = getSessionFactory();
	return sf.openSession();
    }
}
