package nayami.model.dao;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.util.Date;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.HibernateException;
import nayami.model.Bulletin;

public class BulletinDAO extends BaseDAO {

    public BulletinDAO( Session session ){
	super( session );
    }

    public Bulletin findByPrimaryKey( int id )
	throws HibernateException {
	return (Bulletin)session.createQuery( "from Bulletin where id = ?" ).setInteger( 0, id ).uniqueResult();
    }

    public List findByQuestioner( String questioner )
	throws HibernateException {
	return session.createQuery( "from Bulletin where questioner = ? order by modify_date" ).setString( 0, questioner ).list();
    }

    public List findAll() throws HibernateException {
	return session.createQuery( "from Bulletin order by modify_date" ).list();
    }

    public void save( Bulletin bulletin ) throws HibernateException {
	Transaction transaction = null;
	try{
	    Date date = new Date( System.currentTimeMillis() );
	    bulletin.setCreateDate( date );
	    bulletin.setModifyDate( date );
	    transaction = session.beginTransaction();
	    session.save( bulletin );
	    transaction.commit();
	}
	catch( HibernateException e ){
	    if( transaction != null ){
		try {
		    transaction.rollback();
		    session.close();
		}
		catch( HibernateException ignore ){
		}
	    }
	    throw e;
	}
    }

    public void update( Bulletin bulletin ) throws HibernateException {
	Transaction transaction = null;
	try{
	    bulletin.setModifyDate( new Date( System.currentTimeMillis() ) );
	    transaction = session.beginTransaction();
	    session.update( bulletin );
	    transaction.commit();
	}
	catch( HibernateException e ){
	    if( transaction != null ){
		try {
		    transaction.rollback();
		    session.close();
		}
		catch( HibernateException ignore ){
		}
	    }
	    throw e;
	}
    }

    public void delete( Bulletin bulletin ) throws HibernateException {
	Transaction transaction = null;
	try{
	    transaction = session.beginTransaction();
	    session.delete( bulletin );
	    transaction.commit();
	}
	catch( HibernateException e ){
	    if( transaction != null ){
		try {
		    transaction.rollback();
		    session.close();
		}
		catch( HibernateException ignore ){
		}
	    }
	    throw e;
	}
    }
}
