package nayami.services;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.FileInputStream;
import javax.servlet.http.HttpServletRequest;
import org.xml.sax.SAXException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import nayami.model.BookInfo;

public class BookServices {

    private ConfigServices cs;
    private Digester digester;

    private static Log log = LogFactory.getLog( BookServices.class );

    private BookServices( HttpServletRequest request ){
	cs = ConfigServices.getInstance( request );
	ClassLoader cl = getClass().getClassLoader();
	digester = DigesterLoader.createDigester( cl.getResource( cs.getBookDigesterRules() ) );
    }

    public static BookServices getInstance( HttpServletRequest request ){
	return new BookServices( request );
    }

    public BookInfo getBook( String path )
	throws NoSuchDocumentException, SystemException {
	return getBookInfo( cs.getBookDirectory() +
			    System.getProperty( "file.separator" ) +
			    path );
    }

    private BookInfo getBookInfo( String path )
	throws NoSuchDocumentException, SystemException {
	BookInfo bi = null;
	try{
	    log.debug( path + " [h܂B" );
	    bi = (BookInfo)digester.parse( new FileInputStream( path ) );
	}
	catch( FileNotFoundException e ){
	    throw new NoSuchDocumentException( e );
	}
	catch( IOException e ){
	    throw new SystemException( e );
	}
	catch( SAXException e ){
	    throw new SystemException( e );
	}
	return bi;
    }
}
