package nayami.services;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.HibernateException;
import filters.OpenSessionInView;
import nayami.model.Bulletin;
import nayami.model.dao.BulletinDAO;

public class BulletinServices {

    private Session session = null;
    private BulletinDAO bulletinDAO = null;
    private static Log log = LogFactory.getLog( BulletinServices.class );

    private BulletinServices() throws SystemException {
	try{
	    session = OpenSessionInView.getSession();
	}
	catch( HibernateException e ){
	    throw new SystemException( e );
	}
	bulletinDAO = new BulletinDAO( session );
    }

    public static BulletinServices getInstance() throws SystemException {
	return new BulletinServices();
    }

    public Bulletin registerBulletin( String questioner, String question )
	throws SystemException {
	Bulletin bulletin = new Bulletin();
	bulletin.setQuestioner( questioner );
	bulletin.setQuestion( question );
	bulletin.setAnswered( false );
	return registerBulletin( bulletin );
    }

    public Bulletin registerBulletin( Bulletin bulletin )
	throws SystemException {
	try{
	    bulletinDAO.save( bulletin );
	    return bulletin;
	}
	catch( HibernateException e ){
	    throw new SystemException( e );
	}
    }

    public Bulletin registerAnswer( int id, String answer )
	throws SystemException {
	try{
	    Bulletin bulletin = bulletinDAO.findByPrimaryKey( id );
	    if( bulletin == null )
		throw new SystemException( "No such bulletin : " + id );
	    bulletin.setAnswered( true );
	    bulletin.setAnswer( answer );
	    bulletinDAO.update( bulletin );
	    return bulletin;
	}
	catch( HibernateException e ){
	    throw new SystemException( e );
	}
    }

    public List getAllBulletins() throws SystemException {
	try{
	    return bulletinDAO.findAll();
	}
	catch( HibernateException e ){
	    throw new SystemException( e );
	}
    }

    public Bulletin getBulletin( int id )
	throws NoSuchDocumentException, SystemException {
	try{
	    Bulletin bulletin = bulletinDAO.findByPrimaryKey( id );
	    if( bulletin == null )
		throw new NoSuchDocumentException( Integer.toString( id ) );
	    return bulletin;
	}
	catch( HibernateException e ){
	    throw new SystemException( e );
	}
    }
}
