package nayami.services;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.DelayCloseIndexSearcher;

public class SearcherFactory {

    public static final String SEARCHER_FACTORY = "searcherFactory";
    private Directory directory;
    private DelayCloseIndexSearcher currentSearcher;

    private static Log log = LogFactory.getLog( SearcherFactory.class );

    private SearcherFactory( Directory directory ) throws IOException {
	this.directory = directory;
	currentSearcher = new DelayCloseIndexSearcher( directory );
    }

    public static SearcherFactory getInstance( Directory directory ) throws IOException {
	return new SearcherFactory( directory );
    }
    
    public synchronized IndexSearcher createSearcher() throws IOException {
	if( !currentSearcher.isCurrent() ){
	    log.info( "currentSearcher؂ւ܂B" );
	    currentSearcher.closeWhenDone();
	    currentSearcher = new DelayCloseIndexSearcher( directory );
	}
	currentSearcher.open();
        return currentSearcher;
    }
    
    public synchronized void close() throws IOException {
	currentSearcher.closeWhenDone();
    }
}
