package nayami.struts;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.analysis.Analyzer;
import nayami.services.SearcherFactory;
import nayami.config.NayamiConfig;

public class InitializePlugIn implements PlugIn {

    private static Log log = LogFactory.getLog( InitializePlugIn.class );
    private Directory directory = null;
    private SearcherFactory searcherFactory = null;

    public void init( ActionServlet servlet, ModuleConfig config ){

	log.info( "InitializePlugIn.init()N܂B" );

	ServletContext context = servlet.getServletContext();

	NayamiConfig nc = (NayamiConfig)context.getAttribute( "nayamiConfig" );
	String pageSize = Integer.toString( nc.getPageSize() );
	context.setAttribute( "pageSize", pageSize );
	log.info( "y[WTCY: " + pageSize );
	String dirPath = nc.getIndexDirectory();
	log.info( "CfbNXfBNg: " + dirPath );

	try{
	    directory = FSDirectory.getDirectory( dirPath, false );
	    searcherFactory = SearcherFactory.getInstance( directory );
	    log.info( "SearcherFactory擾܂B" );
	    context.setAttribute( SearcherFactory.SEARCHER_FACTORY, searcherFactory );

	    String analyzerClassName = nc.getAnalyzerClassName();
	    ClassLoader cl = getClass().getClassLoader();
	    Analyzer analyzer = (Analyzer)cl.loadClass( analyzerClassName ).newInstance();
	    context.setAttribute( "analyzer", analyzer );
	    log.info( "Analyzer " + analyzerClassName + " [h܂B" );
	    log.info( "Lucene܂B" );
	}
	catch( IOException e ){
	    log.fatal( "LucenȅɎs܂B" + e.toString() );
	}
	catch( ClassNotFoundException e ){
	    log.fatal( "LucenȅɎs܂B" + e.toString() );
	}
	catch( InstantiationException e ){
	    log.fatal( "LucenȅɎs܂B" + e.toString() );
	}
	catch( IllegalAccessException e ){
	    log.fatal( "LucenȅɎs܂B" + e.toString() );
	}
    }

    public void destroy(){

	log.info( "InitializePlugIn.destroy()N܂B" );
	try{
	    if( searcherFactory != null )
		searcherFactory.close();
	    log.info( "SearcherFactoryclose()܂B" );
	}
	catch( IOException e ){
	    log.fatal( e.toString() );
	}
	try{
	    if( directory != null )
		directory.close();
	    log.info( "CfbNXfBNgclose()܂B" );
	}
	catch( IOException e ){
	    log.fatal( e.toString() );
	}
    }
}
