package nayami.struts;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ExceptionHandler;
import org.apache.struts.config.ExceptionConfig;

public class NayamiExceptionHandler extends ExceptionHandler {

    private static Log log = LogFactory.getLog( NayamiExceptionHandler.class );

    public ActionForward execute( Exception ex,
				  ExceptionConfig ec,
				  ActionMapping mapping,
				  ActionForm form,
				  HttpServletRequest request,
				  HttpServletResponse response )
	throws ServletException {
	if( ex instanceof nayami.services.ApplicationException )
	    log.warn( "AvP[VO܂", ex );
	else if( ex instanceof nayami.services.SystemException )
	    log.fatal( "VXeO܂", ex );
	else
	    log.fatal( "̗̑O܂", ex );
	return super.execute( ex, ec, mapping, form, request, response );
    }
}
