package nayami.struts.actions;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForm;
import nayami.struts.forms.validator.AnswerForm;
import nayami.services.BulletinServices;
import nayami.model.Bulletin;

public class AnswerAction extends Action {

    private static Log log = LogFactory.getLog( AnswerAction.class );

    public ActionForward execute( ActionMapping mapping,
				  ActionForm form,
				  HttpServletRequest request,
				  HttpServletResponse response )
	throws Exception {

	// tH[擾
	AnswerForm answerForm = (AnswerForm)form;
	log.debug( "answerForm properties are as follows:" +
		   " id = " + answerForm.getId() +
		   ", answer = " + answerForm.getAnswer() );

	// 񓚂o^
	BulletinServices bs = BulletinServices.getInstance();
	Bulletin bulletin = bs.registerAnswer( answerForm.getId(),
					       answerForm.getAnswer() );

	// Beanɓeeݒ
	BulletinBean bean = new BulletinBean();
	BeanUtils.copyProperties( bean, bulletin );

	// Beanrequestɐݒ
	request.setAttribute( "bulletin", bean );

	return mapping.findForward( "bulletin" );
    }
}
