package nayami.struts.actions;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Enumeration;
import java.net.URLEncoder;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForm;
import nayami.struts.forms.validator.SearchForm;
import nayami.services.SearchServices;
import nayami.services.SearchResult;

public class SearchAction extends Action {

    private static Log log = LogFactory.getLog( SearchAction.class );
    protected static final String ENCODING = "Shift_JIS";
    protected static final String QUERY_EQUAL = "query=";
    protected static final String AMP = "&";
    protected static final String PAGE_BEGIN = "pbgn";
    protected static final String FLAG_ARTICLE = "article";
    protected static final String FLAG_FAQ = "faq";
    protected static final String FLAG_BOOK = "book";
    protected static final String FLAG_BULLETIN = "bulletin";

    public ActionForward execute( ActionMapping mapping,
				  ActionForm form,
				  HttpServletRequest request,
				  HttpServletResponse response )
	throws Exception {

	// fobOp- print all headers
	Enumeration headers = request.getHeaderNames();
	while( headers.hasMoreElements() ){
	    String header = (String)headers.nextElement();
	    log.debug( header + " = " + request.getHeader( header ) );
	}

	// 擾
	SearchForm searchForm = (SearchForm)form;
	String query = getQueryString( request, searchForm );

	// e^CṽtO擾
	boolean flagArticle = getArticleFlag( request, searchForm );
	boolean flagFaq = getFaqFlag( request, searchForm );
	boolean flagBook = getBookFlag( request, searchForm );
	boolean flagBulletin = getBulletinFlag( request, searchForm );

	// y[W̊Jnԍ擾
	int begin = getPageBegin( request );

	// ʂ̃Xg擾
	SearchServices ss = SearchServices.getInstance( request );
	SearchResult searchResult = ss.search( query, flagArticle, flagFaq, flagBook, flagBulletin, begin );

	// ʂrequestɐݒ
	request.setAttribute( "length", Integer.toString( searchResult.getLength() ) );
	request.setAttribute( "items", searchResult.getItems() );

	// requestɐݒ
	request.setAttribute( "query", query );

	// e^CṽtOrequestɐݒ
	request.setAttribute( FLAG_ARTICLE, new Boolean( flagArticle ).toString() );
	request.setAttribute( FLAG_FAQ, new Boolean( flagFaq ).toString() );
	request.setAttribute( FLAG_BOOK, new Boolean( flagBook ).toString() );
	request.setAttribute( FLAG_BULLETIN, new Boolean( flagBulletin ).toString() );

	// GR[hrequestɐݒ
	request.setAttribute( "encq", URLEncoder.encode( query, ENCODING ) );

	return mapping.findForward( "searchResult" );
    }

    protected String getQueryString( HttpServletRequest request,
				     SearchForm form )
	throws UnsupportedEncodingException {

	String qs = request.getQueryString();
	if( qs == null )
	    // tH[擾
	    return form.getSearch();

	int p = qs.indexOf( QUERY_EQUAL );
	if( p < 0 )
	    // tH[擾
	    return form.getSearch();

	// p[^擾
	// ł̓AJ[NĂ΂邽߁AContent-Typewb_[
	// application/x-www-form-urlencodedݒ肳ȂB
	// ̂߁ArequestNG[擾AURLDecoder
	// pKv
	String encQ = qs.substring( p + QUERY_EQUAL.length() );
	p = encQ.indexOf( AMP );
	if( p >= 0 )
	    encQ = encQ.substring( 0, p );
	String decQ = URLDecoder.decode( encQ, ENCODING );

	// NG[tH[ɐݒ
	form.setSearch( decQ );
	return decQ;
    }

    protected boolean getArticleFlag( HttpServletRequest request,
				      SearchForm form ){
	String flag = request.getParameter( FLAG_ARTICLE );
	if( flag == null )
	    return form.getArticle();
	boolean b = Boolean.valueOf( flag ).booleanValue();
	form.setArticle( b );
	return b;
    }

    protected boolean getFaqFlag( HttpServletRequest request,
				  SearchForm form ){
	String flag = request.getParameter( FLAG_FAQ );
	if( flag == null )
	    return form.getFaq();
	boolean b = Boolean.valueOf( flag ).booleanValue();
	form.setFaq( b );
	return b;
    }

    protected boolean getBookFlag( HttpServletRequest request,
				   SearchForm form ){
	String flag = request.getParameter( FLAG_BOOK );
	if( flag == null )
	    return form.getBook();
	boolean b = Boolean.valueOf( flag ).booleanValue();
	form.setBook( b );
	return b;
    }

    protected boolean getBulletinFlag( HttpServletRequest request,
				       SearchForm form ){
	String flag = request.getParameter( FLAG_BULLETIN );
	if( flag == null )
	    return form.getBulletin();
	boolean b = Boolean.valueOf( flag ).booleanValue();
	form.setBulletin( b );
	return b;
    }

    protected int getPageBegin( HttpServletRequest request ){
	String begin = request.getParameter( PAGE_BEGIN );
	if( begin == null )
	    return 0;
	try{
	    return Integer.parseInt( begin );
	}
	catch( NumberFormatException e ){
	    return 0;
	}
    }
}
