package nayami.struts.actions;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForm;
import nayami.model.BookInfo;
import nayami.services.BookServices;

public class ShowBookAction extends Action {

    private static Log log = LogFactory.getLog( ShowBookAction.class );

    public ActionForward execute( ActionMapping mapping,
				  ActionForm form,
				  HttpServletRequest request,
				  HttpServletResponse response )
	throws Exception {

	// requestpath擾
	String path = request.getParameter( "path" );

	// Ѓf[^擾
	BookServices bs = BookServices.getInstance( request );
	BookInfo info = bs.getBook( path );

	// Beanɓeݒ
	BookBean book = new BookBean();
	BeanUtils.copyProperties( book, info );
	
	// Beanrequestɐݒ
	request.setAttribute( "book", book );

	return mapping.findForward( "book" );
    }
}
