package nayami.struts.forms.validator;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.validator.ValidatorForm;
import org.apache.struts.action.ActionMapping;

public class SearchForm extends ValidatorForm {

    private static Log log = LogFactory.getLog( SearchForm.class );
    private String search;
    private boolean article;
    private boolean faq;
    private boolean book;
    private boolean bulletin;
    private boolean initial = true;

    public void setSearch( String search ){
	this.search = search;
    }
    public String getSearch(){
	return this.search;
    }

    public void setArticle( boolean article ){
	this.article = article;
    }
    public boolean getArticle(){
	return this.article;
    }

    public void setFaq( boolean faq ){
	this.faq = faq;
    }
    public boolean getFaq(){
	return this.faq;
    }

    public void setBook( boolean book ){
	this.book = book;
    }
    public boolean getBook(){
	return this.book;
    }

    public void setBulletin( boolean bulletin ){
	this.bulletin = bulletin;
    }
    public boolean getBulletin(){
	return this.bulletin;
    }

    public void reset( ActionMapping mapping, HttpServletRequest request ){
	if( initial ){
	    article = true;
	    faq = true;
	    book = true;
	    bulletin = true;
	    initial = false;
	}
	else{
	    article = false;
	    faq = false;
	    book = false;
	    bulletin = false;
	}
    }
}
