<%@ page contentType="text/html; charset=Shift_JIS" %>
<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ page import="java.util.List" %>

<h1><bean:message key="list.h1.title"/></h1>

<c:set var="num" value="<%= Integer.toString( ((List)request.getAttribute( "bulletins" )).size() ) %>" scope="page"/>
<%@ include file="inc_listHeader.jsp" %>

<c:forEach var="bulletin" items="${bulletins}" begin="${pbgn}" end="${pbgn+psiz-1}">
<p>
  <strong class="list-title">
    <html:link action="/get.do?id=${bulletin.id}">
      ${bulletin.question}
    </html:link>
  </strong><br>
  <strong class="list-date">
    <bean:message key="list.label.date"/>${bulletin.modifyDate}
  </strong><br>
  <c:if test="${!bulletin.answered}">
    <strong class="list-summary">
      <bean:message key="list.label.noAnswer"/>
    </strong><br>
    <strong class="list-link">
      <html:link action="/get.do?id=${bulletin.id}">
	<bean:message key="list.link.answer"/>
      </html:link>
    </strong>
  </c:if>
  <c:if test="${bulletin.answered}">
    <strong class="list-link">
      <html:link action="/get.do?id=${bulletin.id}">
	<bean:message key="list.link.read"/>
      </html:link>
    </strong>
  </c:if>
</p>
</c:forEach>

<%@ include file="inc_listFooter.jsp" %>

<p>
  <html:link action="/home.do">
    <bean:message key="list.link.submit"/>
  </html:link>
</p>
