/**
 *
 */
package solrbook.client.indexing;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;

import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.common.SolrInputDocument;

/**
 * @author $Author$
 * 
 */
public class IndexingSample {

	/**
	 * @param args
	 */
	public static void main(String[] args) {

		try {
			SolrServer server = new CommonsHttpSolrServer(
					"http://localhost:8983/solr");
			SolrInputDocument document = new SolrInputDocument();
			document.addField("url", " http://gihyo.jp/ThisIsSample1");
			document.addField("title", " はじめてのSolr");
			String[] authors = { "山田太郎", "鈴木一郎" };
			document.addField("author", authors);
			document.addField("summary", " この書籍はフィクションです。");

			server.add(document);

			server.commit();

			Collection<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
			document = new SolrInputDocument();
			document.addField("url", " http://gihyo.jp/ThisIsSample1");
			document.addField("title", " はじめてのSolr");
			document.addField("author", authors);
			document.addField("summary", " この書籍はフィクションです。");

			docs.add(document);

			document = new SolrInputDocument();
			document.addField("url", "http://gihyo.jp/ThisIsSample2");
			document.addField("title", "続・はじめてのSolr");
			document.addField("author", authors);
			document.addField("summary", " この書籍もフィクションです。");
			docs.add(document);

			server.add(docs);

			server.commit();

			Book book = new Book();

			book.url = " http://gihyo.jp/ThisIsSample3";
			book.title = "改・はじめてのSolr";
			book.authors = new String[] { "山田太郎", "鈴木一郎" };
			book.summary = "この書籍はフィクションです。";

			server.addBean(book);

			server.commit();

		} catch (MalformedURLException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		} catch (SolrServerException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}

	}
}
