package hello_solr::Example;

use strict;
use warnings;
use base 'hello_solr::Controller';

use utf8;
use Encode;
use Encode::Guess qw/euc-jp shiftjis 7bit-jis/;

use hello_solr::Model;

# for mojo(Mojo-0.999914@CPAN)

sub select {
  my $self = shift;
	#my $c = $self->ctx;
	my $c = $self;

	# 年度表示用変換TBL
	my %hashTmp = (
		'pub_date:[20090101 TO *]'=>'2009年以降',
		'pub_date:[20080101 TO 20081231]'=>'2008年',
		'pub_date:[20070101 TO 20071231]'=>'2007年',
		'pub_date:[20060101 TO 20061231]'=>'2006年',
		'pub_date:[20050101 TO 20051231]'=>'2005年',
		'pub_date:[* TO 20041231]'=>'2004年以前'
	);

	# パンくず表示用TBL生成('[20050101 TO 20051231]'=>'2005年')
	foreach(keys(%hashTmp)){
		my @aryTmp = split(/\:/,$_);
		$hashTmp{$aryTmp[1]} = $hashTmp{$_};
	}
	$hashTmp{'pub_date'} = '発売年';

	# フィルタ表示用変換TBL(年度表示用+α)
	my %hashFilter = (%hashTmp,(
		'genre'=>'ジャンル',
		'keyword'=>'キーワード',
		'author_facet'=>'著者',
	));

	# フィルタ条件があれば引継ぎ
	if(defined($c->req->param('filter'))){
		$c->stash->{filter} = $c->req->param('filter');
	}else{
		$c->stash->{filter} = '';
	}

	# ページ番号が数字でないならホームにリダイレクト(0は初期値の1で来る)
	if($c->stash->{page} !~ /^\d+/){
		$c->app->log->debug('found error with page number! : '.$c->stash->{page});
		return $self->redirect_to('/');
	}

	# フィルタとクエリの受け取り(文字化け対応)
	my $enc = guess_encoding($c->stash->{filter}, qw/euc-jp shiftjis 7bit-jis/);
	Encode::_utf8_off($c->stash->{filter});
	if(ref($enc)){
		$c->app->log->debug("encoding(guess): ".$enc->name);
		$c->stash->{filter} = $enc->decode($c->stash->{filter});
		$c->stash->{query} = $enc->decode($c->stash->{query});
	}else{
		$c->app->log->debug("encoding(guess): none");
		$c->stash->{filter} = decode('utf8',$c->stash->{filter});
		$c->stash->{query} = decode('utf8',$c->stash->{query});
	}

	# フィルタの重複確認
	my @aryTmp = split(/\^/, $c->stash->{filter});
	my %objCnt;
	@aryTmp = grep {!$objCnt{$_}++} @aryTmp;
	$c->stash->{filter} = join('^',@aryTmp);

	# DEBUG
	$c->app->log->debug('filters: '.($#aryTmp)) if($#aryTmp > 0);

	# パンくず作成
	my $strFilter = '';
	foreach my $i (split(/(\^|\:)/, $c->stash->{filter})){
		next if(length($i)<=1);
		if(defined($hashFilter{$i})){
			$strFilter .= $hashFilter{$i};
			if($i =~ /\]$/){
				# 発行年は値も変換TBLで置換されてくる(値も一緒に来る)
				$strFilter .= ' &gt; ';
			}else{
				$strFilter .= ':';
			}
		}else{
			$strFilter .= $i.' &gt; ';
		}
	}
	$c->stash->{filterHTML} = $strFilter;

	# Solrへ問い合わせ
	# フィールド名無しの'*'検索に対応
	$c->stash->{query} = '*:*' if($c->stash->{query} eq '*');
#	my $refRes = $c->app->model->getResult(
	my $refRes = hello_solr::Model->getResult(
		$c->stash->{page} - 1,
		$c->stash->{query},
		$c->stash->{filter}
	);
	$c->stash->{query} = '*' if($c->stash->{query} eq '*:*');

	# タイトル等メタデータの準備
	$c->stash->{title} = 'Solr検索サンプル';
	$c->stash->{meta} = $refRes->{meta};
	$c->stash->{docs} = $refRes->{docs};
	$c->stash->{facet} = $refRes->{facet};

	# QTime(小数点秒に整形)
	$c->stash->{meta}->{qtime} = sprintf("%0.3f",$c->stash->{meta}->{QTime}/1000);

	# 何件目から何件目を表示しているか準備(Rowsが決めうち)
	my $intSum = 10 + $c->stash->{meta}->{start};
	if($intSum < $c->stash->{meta}->{numFound}){
		$c->stash->{meta}->{end} = $intSum;
	}else{
		$c->stash->{meta}->{end} = $c->stash->{meta}->{numFound};
	}

	# ページ合計数の計算(Rowsが決めうち)
	$c->stash->{totalPages} = $c->stash->{meta}->{numFound} / 10;

	# 発行年の変換TBL引渡し
	$c->stash->{mapDateTbl} = \%hashTmp;

	# 結果のドリルダウン情報引渡し
	$c->stash->{fgenre} = $c->stash->{facet}->{genre};
	$c->stash->{fkeyword} = $c->stash->{facet}->{keyword};
	$c->stash->{fauthor} = $c->stash->{facet}->{author_facet};
	$c->stash->{fdate} = $c->stash->{facet}->{date};

	# 表示を整形(著者の"他"でファセットしない等)
	if(defined($c->stash->{fauthor}->{'他'})){
		delete($c->stash->{fauthor}->{'他'});
	}
	foreach(keys %{$c->stash->{fdate}}){
		delete($c->stash->{fdate}->{$_}) if(!$c->stash->{fdate}->{$_});
	}

	# ページナビHTML作成
	$c->stash->{navi} = &paginationHtml($refRes->{pager});

	# ページ作成
	$self->render('example/select', format => 'html', handler => 'ep');
}

# ページングナビの作成関数
sub paginationHtml(){

	my $pager = shift;

	my $p_head = '|&lt;&lt;先頭ページへ';
	my $p_prev = '&lt;前へ';
	my $p_next = '次へ&gt;';
	my $p_tail = '末尾ページへ&gt;&gt;|';

	my $strStart = '<a href="#" onclick="withFilter(';
	my $strEnd = '</a>&nbsp;&nbsp;&nbsp;';

	my $pageHtml = '<strong>Page</strong> : ';

	# HTMLパーツ化(entries_per_pageはデフォルトの10)
	if( $pager->total_entries() > $pager->entries_per_page() ){

		# 前へ&先頭
		if( $pager->previous_page() ){
			$pageHtml .= $strStart.'1)">'.$p_head.$strEnd;
			$pageHtml .= $strStart.($pager->previous_page()-1).')">'.$p_prev.$strEnd;
		}

		# [1]..[N] 全部で5つ出す
		$pageHtml .= "&nbsp;";
		foreach my $i ($pager->pages_in_navigation(5)){
			if( $pager->current_page() == $i){
				$pageHtml .= "".$i."&nbsp;&nbsp;&nbsp;"
			}else{
				$pageHtml .= $strStart.$i.')">'.$i.$strEnd;
			}
		}

		# 次へ&末尾
		$pageHtml .= "&nbsp;";
		if( $pager->next_page() ){
			$pageHtml .= $strStart.($pager->next_page()+1).')">'.$p_next.$strEnd;
			$pageHtml .= $strStart.$pager->last_page().')">'.$p_tail.$strEnd;
		}
		$pageHtml .= "</div>";
	}else{
		# (結果数少なく)ナビが不要な場合
		$pageHtml = '<!-- Navi is not needed -->';
	}
	return $pageHtml;
}

1;
