package hello_solr::Model;

use strict;
use warnings;
use base 'Mojo::Base';

use utf8;
use WebService::Solr;
use Data::Page::Navigation;

sub getResult {
	my $intRows = 10;
	my ($self, $intPage, $strQuery, $strFilter ) = @_;
	my $objResult;

	# フィルタクエリの整形
	my @aryTmp = split(/\^/,$strFilter) if($strFilter);
	@aryTmp = grep(!/^$/, @aryTmp);

	@aryTmp = map { &utf8encode($_) } @aryTmp;
	$strQuery = &utf8encode($strQuery);

	# my $solr = WebService::Solr->new('http://192.168.10.193:8983/solr',());
	my $solr = WebService::Solr->new();
	my $response = $solr->search( $strQuery,
		{
			'fl' => "url,title,price,author,pages,isbn",
			"f.title.hl.alternateField" => "title",
			"f.summary.hl.alternateField" => "summary",
			"f.summary.hl.alternateFieldLength" => "100",
			"hl" => "true",
			'hl.usePhraseHighlighter' => "true",
			'hl.fl' => "title,summary,intended_reader,from_author,toc",
			'hl.simple.pre' => '<b style="background:aquamarine">',
			'hl.simple.post' => "</b>",
			'hl.snippets' => "1",
			"facet" => "on",
			"facet.limit" => "20",
			'facet.sort' => "count",
			'facet.mincount' => "1",
			'facet.field' => ["genre",
				"keyword",
				"author_facet"],
			'facet.query' => ["pub_date:[20090101 TO *]",
				"pub_date:[20080101 TO 20081231]",
				"pub_date:[20070101 TO 20071231]",
				"pub_date:[20060101 TO 20061231]",
				"pub_date:[20050101 TO 20051231]",
				"pub_date:[* TO 20041231]"],
			'rows' => $intRows,
			'start' => $intPage * $intRows,
			'fq' => \@aryTmp
		}
	);

	# 検索結果(ハイライト)を整理
	my $refHighlight;
	foreach my $i (keys(%{$response->content->{highlighting}})){
		# データ不足への対応
		if(defined($response->content->{highlighting}->{$i}->{summary})){
			$refHighlight->{$i}->{summary} = join(', ',@{$response->content->{highlighting}->{$i}->{summary}});
		}else{
			$refHighlight->{$i}->{summary} = '<i>(サマリ情報がありません)</i>';
		}
	}

	# メタ情報(numFoundとstart)を格納
	$objResult->{meta} = $response->content->{response};
	$objResult->{meta}->{QTime} = $response->content->{responseHeader}->{QTime};

	# 検索結果を格納
	for my $doc ( $response->docs ) {

		my $hashTmp;
		my @aryTmp = $doc->values_for( 'author' );
		if($#aryTmp){
			$hashTmp->{author} = join(', ',@aryTmp);
		}elsif(defined($doc->value_for( 'author' ))){
			$hashTmp->{author} = $doc->value_for( 'author' );
		}
		# データ不足への対応
		if(!length($hashTmp->{author})){
			$hashTmp->{author} = '<i>(著者情報がありません)</i>';
		}

		$hashTmp->{title} = $doc->value_for( 'title' );
		$hashTmp->{url} = $doc->value_for( 'url' );
		$hashTmp->{summary} = $refHighlight->{$hashTmp->{url}}->{summary};
		$hashTmp->{isbn} = $doc->value_for( 'isbn' );
		$hashTmp->{price} = $doc->value_for( 'price' );
		$hashTmp->{pages} = $doc->value_for( 'pages' );
		push(@{$objResult->{docs}},$hashTmp);
	}

	# 別に格納したので不要
	$objResult->{meta}->{docs} = ();

	# ファセットカウントをハッシュに変換(配列でやってくるため)
	foreach my $i (('genre','keyword','author_facet')){
		my $hashTmp;
		my @aryTmp = @{$response->facet_counts()->{facet_fields}->{$i}};

		foreach my $j ((0..$#aryTmp)){
			next if ($j%2);
			$hashTmp->{$aryTmp[$j]} = $aryTmp[$j+1]; 
		}

		$objResult->{facet}->{$i} = $hashTmp;
	}

	# 発行年ファセット
	$objResult->{facet}->{date} = $response->facet_counts()->{facet_queries};

	# ページング用objを移送
	$objResult->{pager} = $response->pager;

	return $objResult;
}

sub utf8encode{
  my $url = shift;
  utf8::encode($url);
  return $url;
}

1;
