<?php

class SearchHandler{

  private $solrSelectUrl;
  private $facetFieldLabels; 
  private $fqArray;
  public $query = '';
  public $filters;
  public $facetQueries;

  public function __construct(){
    $this->solrSelectUrl = 'http://localhost:8983/solr/select';
    $this->facetFieldLabels = array('genre'=>'ジャンル', 'keyword'=>'キーワード', 'author_facet'=>'著者');
    $this->facetQueries = array('発売年'=>
      array(
        array('2009年以降'=>'pub_date:[20090101 TO *]')
        , array('2008年'=>'pub_date:[20080101 TO 20081231]')
        , array('2007年'=>'pub_date:[20070101 TO 20071231]')
        , array('2006年'=>'pub_date:[20060101 TO 20061231]')
        , array('2005年'=>'pub_date:[20050101 TO 20051231]')
        , array('2004年以前'=>'pub_date:[* TO 20041231]')
      )
    );
  
    $this->fqArray = array();
    foreach($this->facetQueries as $category => $categoryValue){
      foreach($categoryValue as $entry){
        foreach($entry as $label => $query){
          $this->fqArray[] = $query;
        }
      }
    }
  }

  public function search(){
    $this->query = @$_GET['query'];
    $this->filters = @$_GET['fq'];
    if(!is_array($this->filters)){
      $this->filters = array($this->filters);
    }
    return $this->searchSolr();
  }
  

  public function searchSolr(){
    $params = array(
        'wt'=>'php',
//        'wt'=>'phps',
        'q'=>empty($this->query) ? '*:*' : $this->query,
        'fq'=>$this->filters,
        'start'=>empty($_GET['start']) ? 0 : $_GET['start'],
        'rows'=>'10',
        'fl'=>'url,title,price,author,pages,isbn',
        'hl'=>'true',
        'hl.fl'=>implode(',',array('title','summary','intended_reader','from_author','toc')),
        'hl.snippets'=>'1',
        'f.title.hl.alternateField'=>'title',
        'f.summary.hl.alternateField'=>'summary',
        'f.summary.hl.maxAlternateFieldLength'=>'100',
        'hl.usePhraseHighlighter'=>'true', 
        'hl.simple.pre'=>'<b style="background:aquamarine">', 
        'hl.simple.post'=>'</b>', 
        'facet'=>'on',
        'facet.limit'=>'20',
        'facet.mincount'=>'1',
        'facet.sort'=>'count',
        'facet.field'=>array_keys($this->facetFieldLabels),
        'facet.query'=>$this->fqArray
    );
    $queryString = http_build_query($params, null, '&');
    $queryString = preg_replace('/%5B(?:[0-9]|[1-9][0-9]+)%5D=/', '=', $queryString);
    $rawRes = file_get_contents($this->solrSelectUrl.'?'.$queryString);
    eval("\$rsp = ".$rawRes.";");
//    $rsp = unserialize($rawRes);
    return $rsp;
  }

  public function getLinkStr($filter = '', $start = 0){
    $fq = null;
    if(count($this->filters) > 0 && $filter != ''){
      $fq = array_merge($this->filters,array($filter));
    }else if(count($this->filters) > 0 && $filter == ''){
      $fq = $this->filters;
    }
    $params = array(
      'query'=>$this->query,
      'fq'=>$fq,
      'start'=>$start
    );

    $queryString = http_build_query($params, null, '&');
    return $queryString;
  }

  public function getFacetFieldLabel($fieldName){
    return @array_key_exists($fieldName, $this->facetFieldLabels) ? $this->facetFieldLabels[$fieldName] : $fieldName;
  }

  public function getFacetQueryTotalCount($facetQueries, $categoryList){
    $count = 0;
    foreach($categoryList as $entry){
      foreach($entry as $label => $query){
        $count = $count + $facetQueries[$query];
      }
    }
    return $count;
  }
}

?>