<?php 
require_once('SearchHandler.php');
$handler = new SearchHandler();
$rsp = $handler->search();
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link media="screen" href="./style.css" type="text/css" rel="stylesheet" />
<?php if($handler->query != null ){?>
<title><?php echo htmlspecialchars($handler->query); ?>の検索結果</title>
<?php }else{ ?>
<title>Solr検索サンプル</title>
<?php } ?>
</head>
<body onload="document.f1.query.focus();">
<div id="wrap">
<div id="header">
  <h1><a href="#">Solr検索サンプル</a></h1>
  <br/>
  <form name="f1" action="index.php">
    <input type="text" name="query" value="<?php echo $handler->query ?>"/>
    <input value="検索" type="submit"/>
  </form>
</div>
<?php
$rp = $rsp['responseHeader']['params'];
$found = empty($rsp['response']['numFound']) ? 0 : $rsp['response']['numFound'];
$start = empty($rp['start']) ? 0 : $rp['start'];
$rows = empty($rp['rows']) ? 10 : $rp['rows'];
?>
<?php include('includes/result_header.php'); ?>
<div id="content">
<?php if($found == 0){ ?>
<b><?php echo htmlspecialchars($handler->query); ?></b> は見つかりませんでした。他の検索語で試してください。
<?php }else{ ?>
<div id="result" class="right">
  <?php foreach($rsp['response']['docs'] as $document ){ ?>
    <?php include('includes/document.php'); ?>
  <?php } ?>
</div><!-- end of #result -->

<div id="facet" class="left">
<?php foreach($rsp['facet_counts']['facet_fields'] as $fieldName => $facetPairs ){ ?>
  <?php include('includes/facet_field.php'); ?>
<?php } ?>

<?php foreach($handler->facetQueries as $categoryName => $categoryList){ ?>
  <?php include('includes/facet_queries.php'); ?>
<?php } ?>
</div><!-- end of #facet -->
<?php } ?>

<div style="CLEAR: both"></div>

</div><!-- end of #content -->

<?php include('includes/pagination.php'); ?>

<div id="footer">著作権表示など</div></div></body>
</html>


