# -*- coding: utf-8 -*-

FACET_QUERIES = ({
  '発売年':
  [
   {'2009年以降':'pub_date:[20090101 TO *]'}
   , {'2008年':'pub_date:[20080101 TO 20081231]'}
   , {'2007年':'pub_date:[20070101 TO 20071231]'}
   , {'2006年':'pub_date:[20060101 TO 20061231]'}
   , {'2005年':'pub_date:[20050101 TO 20051231]'}
   , {'2004年以前':'pub_date:[* TO 20041231]'}
  ]
  })
FACET_LABELS = ({
  'genre':'ジャンル'
  , 'keyword':'キーワード'
  , 'author_facet':'著者'
  })

def get_facet_queries_array():
  facet_queries_array = []
  for label,list in FACET_QUERIES.iteritems():
    for q_map in list:
      for name, query in q_map.iteritems():
        facet_queries_array.append(query)
  
  return facet_queries_array

def get_facet_queries_sum_count(category, facet_queries):
  count = 0
  for query_entry in FACET_QUERIES[category]:
    for label,query in query_entry.iteritems():
      count = count + facet_queries[query]
  return count

def get_facet_query_count(query,facet_queries):
  count = 0
  if facet_queries.has_key(query):
    count = facet_queries[query]
  return count

def get_base_link_str(inparams):
  params = []
  if inparams.has_key('query'):
    params.append(('query',inparams['query'].encode('UTF-8')))
  if inparams.has_key('fq'):
    for value in inparams['fq']:
      params.append(('fq',value.encode('UTF-8')))
  return params
  
