# -*- coding: utf-8 -*-
from sampleapp import helper
import math

class SamplePaginator(object):

  def __init__(self, start, rows, found):
    self.rows = rows
    self.start = start
    self.found = found
    self.links = []

    wsiz = 10
    w1 = 5
    w2 = 5

    self.pcnt = int(math.ceil( float(self.found) / float(self.rows))) 
    self.cpag = self.start / self.rows + 1
    self.wbgn = self.cpag - w1
    self.wend = self.cpag + w2
    if self.wbgn < 1:
      self.wbgn = 1
      self.wend = self.wbgn + wsiz
      if self.wend > self.pcnt + 1:
        self.wend = self.pcnt +1
    if self.wend > self.pcnt +1:
      self.wend = self.pcnt +1
      self.wbgn = self.wend - wsiz
      if self.wbgn < 1:
        self.wbgn = 1
    page_numbers = range(self.wbgn , self.wend)
    links = []
    for i in page_numbers:
      if i == self.cpag:
        links.append(str(i))
      else:
        links.append({'start':((i-1)*self.rows), 'number':i})
    self.links = links

  def has_next(self):
    return self.cpag < self.pcnt

  def has_previous(self):
    return self.cpag > 1

  def next_start_number(self):
    return self.cpag * self.rows

  def previous_start_number(self):
    return (self.cpag - 2) * self.rows

  def end_start_number(self):
    return (self.pcnt - 1) * self.rows

  def page_count(self):
    return  self.pcnt


