# -*- coding: utf-8 -*-
from django import template
from sampleapp import helper
import urllib

register = template.Library()

@register.filter()
def get_highlighted_title(url, rsp):
  hi = rsp['highlighting'][url]
  return hi['title'][0]

@register.filter()
def get_summary(url, rsp):
  hi = rsp['highlighting'][url]
  snippets = []
  for field in ['summary','intended_reader','from_author','toc']:
    if hi.has_key(field):
      snippets += hi[field]
  return '...'.join(snippets)

@register.filter()
def get_facet_label(field_name):
  label = field_name
  if helper.FACET_LABELS.has_key(field_name):
    label = helper.FACET_LABELS[field_name]
  return label

@register.filter()
def get_facet_query_count(query,facet_queries):
  return helper.get_facet_query_count(query,facet_queries)

@register.filter()
def get_fq_str(field_name,value):
  return field_name+':'+value

@register.filter()
def get_facet_link(fq,inparams):
  params = helper.get_base_link_str(inparams)
  params.append(('fq',fq.encode('UTF-8')))
  return urllib.urlencode(params)

@register.filter()
def get_page_link(inparams,start):
  params = helper.get_base_link_str(inparams)
  params.append(('start',start))
  return urllib.urlencode(params)
