module SearchHelper

  def facet_query_total_count( facet_queries, fq_array )
    count = 0
    fq_array.each do |args|
      args.each do |k,v|
        count = count + facet_queries[k]
      end
    end
    return count
  end

  def facet_label( field )
    labels = { 'genre'=>'ジャンル', 'keyword'=>'キーワード', 'author_facet'=>'著者' }
    labels[field] || field
  end

  def add_filter( filters, field, name )
    add_filter_query( filters, "#{field}:#{name}" )
  end

  def add_filter_query( filters, name )
    fs = filters.dup
    fs << name unless fs.include?( name )
    fs.join( '/' )
  end

  def display_query_text( query )
    ( query == nil || query == '*:*' ) ? nil : query
  end

  def display_title( query )
    q = display_query_text( query )
    q == nil ? "Solr検索サンプル" : q + "の検索結果"
  end

  def display_result_title( query )
    q = display_query_text( query )
    q == nil ? "" : "<b>#{q}</b> の検索結果&nbsp;&nbsp;&nbsp;"
  end

end
